﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Uznavayko.NeyronNetwork.UznavaykoNetwork
{
  ///<summary>
  ///Simple struct contains InputVector and Output double.
  ///</summary>
  public class UznavaykoSample
  {

    /// <summary>
    /// inputVector
    /// </summary>
    internal double[] inputVector;

    /// <summary>
    /// inputVectorSchema
    /// </summary>
    private static IEnumerable<ParameterName> inputVectorSchema;

    /// <summary>
    /// Gets the input vector.
    /// </summary>
    /// <param name="schemaOfReturnVector">The schema of return vector.</param>
    /// <returns></returns>
    private IEnumerable<double> GetInputVector(
     IEnumerable<ParameterName> schemaOfReturnVector)
    {
      if (schemaOfReturnVector.Contains(nameOfTheOutput))
      {
        throw new InvalidOperationException(
          "Invalid schemaOfReturnVector");
      }

      foreach (ParameterName parameterName in schemaOfReturnVector)
      {
        switch (parameterName)
        {
          case ParameterName.firstChar:
            yield return inputVector[0];
            break;
          case ParameterName.firstCode:
            if (nameOfTheOutput != ParameterName.firstChar)
            {
              yield return inputVector[1];
            }
            else
            {
              yield return inputVector[0];
            }
            break;
          case ParameterName.firstCodePressTime:
            if (nameOfTheOutput != ParameterName.firstChar &&
              nameOfTheOutput != ParameterName.firstCode)
            {
              yield return inputVector[2];
            }
            else
            {
              yield return inputVector[1];
            }
            break;
          case ParameterName.hoursOfTheDay:
            if (nameOfTheOutput != ParameterName.firstChar &&
              nameOfTheOutput != ParameterName.firstCode &&
              nameOfTheOutput != ParameterName.firstCodePressTime)
            {
              yield return inputVector[3];
            }
            else
            {
              yield return inputVector[2];
            }
            break;
          case ParameterName.milliseconds:
            if (nameOfTheOutput != ParameterName.firstChar &&
              nameOfTheOutput != ParameterName.firstCode &&
              nameOfTheOutput != ParameterName.firstCodePressTime &&
              nameOfTheOutput != ParameterName.hoursOfTheDay)
            {
              yield return inputVector[4];
            }
            else
            {
              yield return inputVector[3];
            }
            break;
          case ParameterName.secondChar:
            if (nameOfTheOutput != ParameterName.firstChar &&
              nameOfTheOutput != ParameterName.firstCode &&
              nameOfTheOutput != ParameterName.firstCodePressTime &&
              nameOfTheOutput != ParameterName.hoursOfTheDay &&
              nameOfTheOutput != ParameterName.milliseconds)
            {
              yield return inputVector[5];
            }
            else
            {
              yield return inputVector[4];
            }
            break;
          case ParameterName.secondCode:
            if (nameOfTheOutput != ParameterName.firstChar &&
              nameOfTheOutput != ParameterName.firstCode &&
              nameOfTheOutput != ParameterName.firstCodePressTime &&
              nameOfTheOutput != ParameterName.hoursOfTheDay &&
              nameOfTheOutput != ParameterName.milliseconds &&
              nameOfTheOutput != ParameterName.secondChar)
            {
              yield return inputVector[6];
            }
            else
            {
              yield return inputVector[5];
            }
            break;
          case ParameterName.secondCodePressTime:
            if (nameOfTheOutput != ParameterName.firstChar &&
              nameOfTheOutput != ParameterName.firstCode &&
              nameOfTheOutput != ParameterName.firstCodePressTime &&
              nameOfTheOutput != ParameterName.hoursOfTheDay &&
              nameOfTheOutput != ParameterName.milliseconds &&
              nameOfTheOutput != ParameterName.secondChar &&
              nameOfTheOutput != ParameterName.secondCode)
            {
              yield return inputVector[7];
            }
            else
            {
              yield return inputVector[6];
            }
            break;
        }
      }
    }

    /// <summary>
    /// Gets the input array.
    /// </summary>
    /// <param name="nameOfTheOutput">The name of the output.</param>
    /// <param name="parameters">The parameters.</param>
    /// <returns></returns>
    public static double[] GetInputArray(
      ParameterName nameOfTheOutput,
      IDictionary<ParameterName, double> parameters)
    {
      switch (nameOfTheOutput)
      {
        case ParameterName.firstChar:
          return new[]
                   {
                     parameters[ParameterName.firstCode],
                     parameters[ParameterName.firstCodePressTime],
                     parameters[ParameterName.hoursOfTheDay],
                     parameters[ParameterName.milliseconds], 
                     parameters[ParameterName.secondChar],
                     parameters[ParameterName.secondCode],
                     parameters[ParameterName.secondCodePressTime]
                   };
        case ParameterName.firstCode:
          return new[]
                   {
                     parameters[ParameterName.firstChar],
                     parameters[ParameterName.firstCodePressTime],
                     parameters[ParameterName.hoursOfTheDay],
                     parameters[ParameterName.milliseconds], 
                     parameters[ParameterName.secondChar],
                     parameters[ParameterName.secondCode],
                     parameters[ParameterName.secondCodePressTime]
                   };
        case ParameterName.firstCodePressTime:
          return new[]
                   {
                     parameters[ParameterName.firstChar],
                     parameters[ParameterName.firstCode],
                     parameters[ParameterName.hoursOfTheDay],
                     parameters[ParameterName.milliseconds], 
                     parameters[ParameterName.secondChar],
                     parameters[ParameterName.secondCode],
                     parameters[ParameterName.secondCodePressTime]
                   };
        case ParameterName.hoursOfTheDay:
          return new[]
                   {
                     parameters[ParameterName.firstChar],
                     parameters[ParameterName.firstCode],
                     parameters[ParameterName.firstCodePressTime],
                     parameters[ParameterName.milliseconds], 
                     parameters[ParameterName.secondChar],
                     parameters[ParameterName.secondCode],
                     parameters[ParameterName.secondCodePressTime]
                   };
        case ParameterName.milliseconds:
          return new[]
                   {
                     parameters[ParameterName.firstChar],
                     parameters[ParameterName.firstCode],
                     parameters[ParameterName.firstCodePressTime],
                     parameters[ParameterName.hoursOfTheDay],
                     parameters[ParameterName.secondChar],
                     parameters[ParameterName.secondCode],
                     parameters[ParameterName.secondCodePressTime]
                   };
        case ParameterName.secondChar:
          return new[]
                   {
                     parameters[ParameterName.firstChar],
                     parameters[ParameterName.firstCode],
                     parameters[ParameterName.firstCodePressTime],
                     parameters[ParameterName.hoursOfTheDay],
                     parameters[ParameterName.milliseconds], 
                     parameters[ParameterName.secondCode],
                     parameters[ParameterName.secondCodePressTime]
                   };
        case ParameterName.secondCode:
          return new[]
                   {
                     parameters[ParameterName.firstChar],
                     parameters[ParameterName.firstCode],
                     parameters[ParameterName.firstCodePressTime],
                     parameters[ParameterName.hoursOfTheDay],
                     parameters[ParameterName.milliseconds], 
                     parameters[ParameterName.secondChar],
                     parameters[ParameterName.secondCodePressTime]
                   };
        case ParameterName.secondCodePressTime:
          return new[]
                   {
                     parameters[ParameterName.firstChar],
                     parameters[ParameterName.firstCode],
                     parameters[ParameterName.firstCodePressTime],
                     parameters[ParameterName.hoursOfTheDay],
                     parameters[ParameterName.milliseconds], 
                     parameters[ParameterName.secondChar],
                     parameters[ParameterName.secondCode]
                   };
      }
      throw new ArgumentOutOfRangeException();
    }

    /// <summary>
    /// Converts Sample to dictionary.
    /// </summary>
    /// <param name="nameOfTheOutput">The name of the output.</param>
    /// <param name="sample">The sample.</param>
    /// <returns></returns>
    public static IDictionary<ParameterName, double> ToDictionary(
      ParameterName nameOfTheOutput, UznavaykoSample sample)
    {
      switch (nameOfTheOutput)
      {
        case ParameterName.firstChar:
          return new Dictionary<ParameterName, double>
          {
          {ParameterName.firstChar,sample.OutputVector},
          { ParameterName.firstCode,sample.inputVector[0]},
          { ParameterName.firstCodePressTime,sample.inputVector[1]},
          { ParameterName.hoursOfTheDay,sample.inputVector[2]},
          { ParameterName.milliseconds,sample.inputVector[3]},
          { ParameterName.secondChar,sample.inputVector[4]},
          { ParameterName.secondCode,sample.inputVector[5]},
          { ParameterName.secondCodePressTime,sample.inputVector[6]}
          };
        case ParameterName.firstCode:
          return new Dictionary<ParameterName, double>
          {
          {ParameterName.firstChar,sample.inputVector[0]},
          { ParameterName.firstCode,sample.OutputVector},
          { ParameterName.firstCodePressTime,sample.inputVector[1]},
          { ParameterName.hoursOfTheDay,sample.inputVector[2]},
          { ParameterName.milliseconds,sample.inputVector[3]},
          { ParameterName.secondChar,sample.inputVector[4]},
          { ParameterName.secondCode,sample.inputVector[5]},
          { ParameterName.secondCodePressTime,sample.inputVector[6]}
          };
        case ParameterName.firstCodePressTime:
          return new Dictionary<ParameterName, double>
          {
          {ParameterName.firstChar,sample.inputVector[0]},
          { ParameterName.firstCode,sample.inputVector[1]},
          { ParameterName.firstCodePressTime,sample.OutputVector},
          { ParameterName.hoursOfTheDay,sample.inputVector[2]},
          { ParameterName.milliseconds,sample.inputVector[3]},
          { ParameterName.secondChar,sample.inputVector[4]},
          { ParameterName.secondCode,sample.inputVector[5]},
          { ParameterName.secondCodePressTime,sample.inputVector[6]}
          };
        case ParameterName.hoursOfTheDay:
          return new Dictionary<ParameterName, double>
          {
          {ParameterName.firstChar,sample.inputVector[0]},
          { ParameterName.firstCode,sample.inputVector[1]},
          { ParameterName.firstCodePressTime,sample.inputVector[2]},
          { ParameterName.hoursOfTheDay,sample.OutputVector},
          { ParameterName.milliseconds,sample.inputVector[3]},
          { ParameterName.secondChar,sample.inputVector[4]},
          { ParameterName.secondCode,sample.inputVector[5]},
          { ParameterName.secondCodePressTime,sample.inputVector[6]}
          };
        case ParameterName.milliseconds:
          return new Dictionary<ParameterName, double>
          {
          {ParameterName.firstChar,sample.inputVector[0]},
          { ParameterName.firstCode,sample.inputVector[1]},
          { ParameterName.firstCodePressTime,sample.inputVector[2]},
          { ParameterName.hoursOfTheDay,sample.inputVector[3]},
          { ParameterName.milliseconds,sample.OutputVector},
          { ParameterName.secondChar,sample.inputVector[4]},
          { ParameterName.secondCode,sample.inputVector[5]},
          { ParameterName.secondCodePressTime,sample.inputVector[6]}
          };
        case ParameterName.secondChar:
          return new Dictionary<ParameterName, double>
          {
          {ParameterName.firstChar,sample.inputVector[0]},
          { ParameterName.firstCode,sample.inputVector[1]},
          { ParameterName.firstCodePressTime,sample.inputVector[2]},
          { ParameterName.hoursOfTheDay,sample.inputVector[3]},
          { ParameterName.milliseconds,sample.inputVector[4]},
          { ParameterName.secondChar,sample.OutputVector},
          { ParameterName.secondCode,sample.inputVector[5]},
          { ParameterName.secondCodePressTime,sample.inputVector[6]}
          };
        case ParameterName.secondCode:
          return new Dictionary<ParameterName, double>
          {
          {ParameterName.firstChar,sample.inputVector[0]},
          { ParameterName.firstCode,sample.inputVector[1]},
          { ParameterName.firstCodePressTime,sample.inputVector[2]},
          { ParameterName.hoursOfTheDay,sample.inputVector[3]},
          { ParameterName.milliseconds,sample.inputVector[4]},
          { ParameterName.secondChar,sample.inputVector[5]},
          { ParameterName.secondCode,sample.OutputVector},
          { ParameterName.secondCodePressTime,sample.inputVector[6]}
          };
        case ParameterName.secondCodePressTime:
          return new Dictionary<ParameterName, double>
          {
          {ParameterName.firstChar,sample.inputVector[0]},
          { ParameterName.firstCode,sample.inputVector[1]},
          { ParameterName.firstCodePressTime,sample.inputVector[2]},
          { ParameterName.hoursOfTheDay,sample.inputVector[3]},
          { ParameterName.milliseconds,sample.inputVector[4]},
          { ParameterName.secondChar,sample.inputVector[5]},
          { ParameterName.secondCode,sample.inputVector[6]},
          { ParameterName.secondCodePressTime,sample.OutputVector}
          };
      }
      throw new ArgumentOutOfRangeException();
    }

    /// <summary>
    /// Name of the outpets vector parameter.
    /// </summary>
    public ParameterName nameOfTheOutput;

    /// <summary>
    /// Initializes a new instance of the 
    /// <see cref="UznavaykoSample"/> class.
    /// </summary>
    /// <param name="nameOfTheOutput">The name of the output.</param>
    /// <param name="parameters">The parameters.</param>
    public UznavaykoSample(ParameterName nameOfTheOutput,
      IDictionary<ParameterName, double> parameters)
    {
      this.nameOfTheOutput = nameOfTheOutput;

      InputVector =
        GetInputArray(nameOfTheOutput, parameters);
      OutputVector =
        parameters[nameOfTheOutput];
    }

    /// <summary>
    /// Schema of the input vector, if null then all sevnt parameters.
    /// </summary>
    public static IEnumerable<ParameterName> InputVectorSchema
    {
      get { return inputVectorSchema; }
      set { inputVectorSchema = value; }
    }

    public double[] InputVector
    {
      get
      {
        if (inputVectorSchema == null)
        {
          throw new ArgumentNullException("inputVectorSchema");
        }
        return GetInputVector(inputVectorSchema).ToArray();
      }
      private set { inputVector = value; }
    }

    public double OutputVector
    {
      get;
      private set;
    }
  }
}
