// WindowsHooks.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "windows.h"

#define GET_X_PARAM(lp)                        
#define GET_Y_PARAM(lp)                        ((int)(short)HIWORD(lp))

HINSTANCE appInstance = NULL;

HHOOK hookMouseLL = NULL;

typedef void (CALLBACK *HookProc)(int code, WPARAM w, LPARAM l);

static LRESULT CALLBACK MouseLLHookCallback(int code, WPARAM wparam, LPARAM lparam);

HookProc OnMouseStateChanged;

BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
                     )
{
	OnMouseStateChanged = NULL;
	hookMouseLL = NULL;
	appInstance = NULL;
    if ((ul_reason_for_call == DLL_PROCESS_ATTACH) && (appInstance == NULL))
    {
        appInstance = hModule;
    }
    return TRUE;
}

void SetManagedCallbackFunction(HookProc callbackFunc)
{
	OnMouseStateChanged = callbackFunc;
}

bool SetMouseLLHook(int threadID)
{
    if (appInstance == NULL)
    {
        return false;
    }

    hookMouseLL = SetWindowsHookEx(WH_MOUSE_LL, (HOOKPROC)MouseLLHookCallback, appInstance, threadID);
    return hookMouseLL != NULL;
}

void RemoveMouseLLHook()
{
    if (hookMouseLL != NULL)
	{
        UnhookWindowsHookEx(hookMouseLL);
	}
    hookMouseLL = NULL;
}

static LRESULT CALLBACK MouseLLHookCallback(int code, WPARAM wparam, LPARAM lparam)
{
    if (code >= 0 && OnMouseStateChanged)
    {
        OnMouseStateChanged(code, wparam, lparam);
    }

    return CallNextHookEx(hookMouseLL, code, wparam, lparam);
}

bool GetCoordinatesFromLPARAM(LPARAM lParam, int &x, int &y)
{
	MOUSEHOOKSTRUCT * pMouseStruct = (MOUSEHOOKSTRUCT *)lParam;

	if (pMouseStruct == NULL)
	{
		return false;
	}
	
	x = pMouseStruct->pt.x;
	y = pMouseStruct->pt.y;

	return true;
}


