using System;
using System.Collections.Generic;
using System.Text;

namespace MouseAnalyzer.MouseTraits
{

    public enum MouseButton
    {
        Left,
        Right,
        Middle
    }

    class ClickMouseTrait : ITrait
    {
        private int _timeout;

        public int Timeout
        {
            get { return _timeout; }
        }

        private MouseButton _button;

        public MouseButton Button
        {
            get { return _button; }
        }

        public ClickMouseTrait(int timeout, MouseButton button)
        {
            _timeout = timeout;
            _button = button;
        }

        #region ITrait Members

        public double[] GenerateTraitVector()
        {
            return new double[]
            {
                Timeout
            };
        }

        #endregion
    }
}
