using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using MouseAnalyzer.SecurityAlgorithms;
using System.IO;
using System.Windows.Forms;

namespace MouseAnalyzer.Managers
{

    public delegate void CheckingResultAvailableEventHandler(object sender, CheckingResultAvailableEventArgs e);

    class SecurityManager
    {
        private const string AlgorithmsFileNameFormat = "SecurityAlgorithm{0}.alg";

        public event CheckingResultAvailableEventHandler CheckingResultAvailable;

        private SecurityManagerState _state;

        public SecurityManagerState State
        {
            get { return _state; }
            set { _state = value; }
        }

        private List<ISecurityAlgorithm> _securityAlgorithms;

        public SecurityManager()
        {
            _state = SecurityManagerState.Inactive;
            _securityAlgorithms = new List<ISecurityAlgorithm>();
         //   _securityAlgorithms.Add(new NeuroNetAlgorithm());
            _securityAlgorithms.Add(new TraitsTreeSecurityAlgorithm());
            TraitsManager.GetIntstance().NewTraitsVectorAvailable += new TraitVectorAvailableEventHandler(OnNewTraitsVectorAvailable);
        }

        public void LoadAlgorithms()
        {
            for (int i = 0; i < _securityAlgorithms.Count; i++)
            {
                ISecurityAlgorithm algorithm = _securityAlgorithms[i];
                string fileName = Path.Combine(Application.StartupPath, string.Format(AlgorithmsFileNameFormat, i.ToString()));
                if (File.Exists(fileName))
                {
                    algorithm.Load(fileName);
                }
            }
        }

        public void SaveAlgorithms()
        {
            for (int i = 0; i < _securityAlgorithms.Count; i++)
            {
                ISecurityAlgorithm algorithm = _securityAlgorithms[i];
                string fileName = Path.Combine(Application.StartupPath, string.Format(AlgorithmsFileNameFormat, i.ToString()));
                algorithm.Save(fileName);
            }
        }

        private void OnNewTraitsVectorAvailable(object sender, TraitVectorAvailableEventArgs e)
        {
            for (int i = 0; i < _securityAlgorithms.Count; i++)
            {
                ISecurityAlgorithm algorithm = _securityAlgorithms[i];
                if (_state == SecurityManagerState.Learning)
                {
                    algorithm.LearnVector(e.TraitsVector);
                }
                else if (_state == SecurityManagerState.Monitoring)
                {
                    ProceedResult(algorithm.CheckVector(e.TraitsVector), i, algorithm.Name);
                }
            }
        }

        private void ProceedResult(double checkingResult, int algorithmID, string algorithmName)
        {
            OnCheckingResultAvailable(this, new CheckingResultAvailableEventArgs(checkingResult, algorithmName, algorithmID));
        }

        private void OnCheckingResultAvailable(object sender, CheckingResultAvailableEventArgs e)
        {
            CheckingResultAvailableEventHandler tempEventHandler = CheckingResultAvailable;
            if (tempEventHandler != null)
            {
                tempEventHandler(sender, e);
            }
        }
 
    }
}
