using System;
using System.Collections.Generic;
using System.Text;

namespace MouseAnalyzer.Managers
{
    public class CheckingResultAvailableEventArgs : EventArgs
    {
        private string _algorithmName;
        public string AlgorithmName
        {
            get { return _algorithmName; }
        }

        private int _algorithmID;
        public int AlgorithmID
        {
            get { return _algorithmID; }
        }

        private double _result;
        public double Result
        {
            get { return _result; }
        }

        public CheckingResultAvailableEventArgs(double result, string algorithmName, int algorithmID)
        {
            _result = result;
            _algorithmID = algorithmID;
            _algorithmName = _algorithmName;
        }
    }
}
