using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using System.Drawing;

namespace MouseAnalyzer.Wrapper
{

    public class GlobalMouseEventArgs : EventArgs
    {

        private MouseEventType _eventType;
        public MouseEventType EventType
        {
            get { return _eventType; }
        }

        private int _eventCode;
        public int EventCode
        {
            get { return _eventCode; }
        }


        private int _x;
        public int X
        {
            get { return _x; }
        }

        private int _y;
        public int Y
        {
            get { return _y; }
        }

        public GlobalMouseEventArgs(int eventCode, int x, int y)
        {
            if (Enum.IsDefined(typeof(MouseEventType), eventCode))
            {
                _eventType = (MouseEventType)eventCode;
            }
            else
            {
                _eventType = MouseEventType.Unknown;
            }
            _eventCode = eventCode;
            _x = x;
            _y = y;
        }

        public GlobalMouseEventArgs(MouseEventType eventType, int x, int y)
        {
            _eventType = eventType;
            _eventCode = (int)_eventType;
            _x = x;
            _y = y;
        }
    }
}