#include "queue.h"
#include <iostream>
#include <stdlib.h>

Queue *createQueue()
{
	Queue *result = new Queue;
	result->first = NULL;
	result->last = NULL;
	result->size = 0;
	return result;
}

void destroy(Queue *queue)
{
	while (!isEmpty(queue))
	{
		get(queue);
	}
}

/*
int size(Queue *queue)
{
	QueueElement *current = queue->first;
	int count = 0;
	while (current != NULL)
	{
		current = current->next;
		count++;
	}
	return count;
}
*/
bool isEmpty(Queue *queue) 
{
	return queue->size == 0;
}
int size(Queue *queue)
{
	return queue->size;
}

int get(Queue *queue)
{
	if (size(queue) == 0)
	{
		std::cout << "Queue is empty." << std::endl;
		return -1;
	}
	int value = queue->first->value;
	QueueElement  *tmp = queue->first;
	queue->first = queue->first->next;
	delete tmp;
	queue->size--;
	if (size(queue) == 0)
		queue->last = NULL;
	return value;
}

void add(Queue *queue, int value)
{
	QueueElement *temp = new QueueElement;
	temp->value = value;
	temp->next = NULL;
	if (size(queue) == 0)
		queue->first = temp;
	else
		queue->last->next = temp;
	queue->last = temp;
	queue->size++;
}