#include <iostream>
#include "stack.h"

using std::cout;
using std::endl;

void testEmpty()
{
	cout << "testEmpty:" << endl;
	Stack *stack = createStack();
	cout << "  is empty: " << isEmpty(stack) << endl;
}

void testPush()
{
	cout << "testPush:" << endl;
	Stack *stack = createStack();
	cout << "  is empty before push: " << isEmpty(stack) << endl;
	push(stack, 5);
	cout << "  is empty after push: " << isEmpty(stack) << endl;
}

void testTop()
{
	cout << "testTop:" << endl;
	Stack *stack = createStack();
	push(stack, 5);	
	int value = top(stack);
	cout << "  top: " << value << endl;
}

void testPop()
{
	cout << "testTop:" << endl;
	Stack *stack = createStack();
	push(stack, 5);	
	int value = pop(stack);
	cout << "  pop: " << value << endl;
	cout << "  is empty before pop: " << isEmpty(stack) << endl;
}

int main()
{
	testEmpty();
	testPush();
	testTop();
	testPop();
	int n;
	std::cin >> n;
}