#include <stdlib.h>
#include "bst.h"

Tree *createTree()
{
    Tree *tree = new Tree;
    tree->root = NULL;
    return tree;
}

bool exists(TreeNode *root, int value)
{
    if (root == NULL)
        return false;
    if (root->value == value)
        return true;
    if (root->value > value)
        return exists(root->left, value);
    else
        return exists(root->right, value);
}

bool exists(Tree *tree, int value)
{
    return exists(tree->root, value);
}

TreeNode *createNode(int value)
{
    TreeNode *node = new TreeNode;
    node->value = value;
    node->left = NULL;
    node->right = NULL;
    return node;
}

void add(TreeNode *&node, int value)
{
    if (node == NULL)
    {
        node = createNode(value);
        return;
    }

    if (value < node->value)
        add(node->left, value);
    else
        add(node->right, value);
}

void add(Tree *tree, int value)
{
    add(tree->root, value);
}

TreeNode *leftmostChild(TreeNode *node)
{
    if (node->left != NULL)
        return leftmostChild(node->left);
    else
        return node;
}

bool isLeaf(TreeNode *node)
{
    return (node->left == NULL && node->right == NULL);
}

bool hasOneChild(TreeNode *node)
{
    return ((node->left != NULL && node->right == NULL)
            || (node->left == NULL && node->right != NULL));
}

void remove(TreeNode *&node, int value)
{
    if (node->value > value)
        remove(node->left, value);
    else if (node->value < value)
        remove(node->right, value);
    else if (isLeaf(node))
    {
        delete node;
        node = NULL;
    }
    else if (hasOneChild(node))
    {
        if (node->left != NULL)
        {
            TreeNode *temp = node->left;
            delete node;
            node = temp;
        }
        else if (node->right != NULL)
        {
            TreeNode *temp = node->right;
            delete node;
            node = temp;
        }
    }
    else
    {
        TreeNode *temp = leftmostChild(node->right);
        node->value = temp->value;
        remove(temp, temp->value);
    }
}

void remove(Tree *tree, int value)
{
    if (!exists(tree, value))
       return;
    remove(tree->root, value);
}
